/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.operation;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.tarantool.client.operation.Operation;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
public final class SimpleOperation
implements Operation {
    private final char operator;
    private final Object fieldIdentifier;
    private final Object value;

    public SimpleOperation(char operator, String fieldName, Object value) throws IllegalArgumentException {
        if (fieldName == null || fieldName.equals("")) {
            throw new IllegalArgumentException("fieldName can't be null or empty string");
        }
        if (value == null) {
            throw new IllegalArgumentException("value can't be null, but it can be empty list");
        }
        this.operator = operator;
        this.fieldIdentifier = fieldName;
        this.value = value;
    }

    public SimpleOperation(char operator, int fieldIndex, Object value) throws IllegalArgumentException {
        if (fieldIndex == 0) {
            throw new IllegalArgumentException("fieldIndex can't be null or zero");
        }
        if (value == null) {
            throw new IllegalArgumentException("value can't be null, but it can be empty list");
        }
        this.operator = operator;
        this.fieldIdentifier = fieldIndex;
        this.value = value;
    }

    @Override
    public char getOperator() {
        return this.operator;
    }

    @Override
    public Object getFieldIdentifier() {
        return this.fieldIdentifier;
    }

    public Object getValue() {
        return this.value;
    }
}

