/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.factory;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import io.tarantool.balancer.TarantoolBalancer;
import io.tarantool.client.Options;
import io.tarantool.client.crud.Condition;
import io.tarantool.client.crud.TarantoolCrudSpace;
import io.tarantool.client.crud.UpsertBatch;
import io.tarantool.client.crud.options.CountOptions;
import io.tarantool.client.crud.options.CrudOptions;
import io.tarantool.client.crud.options.DeleteOptions;
import io.tarantool.client.crud.options.GetOptions;
import io.tarantool.client.crud.options.InsertManyOptions;
import io.tarantool.client.crud.options.InsertOptions;
import io.tarantool.client.crud.options.LenOptions;
import io.tarantool.client.crud.options.MinMaxOptions;
import io.tarantool.client.crud.options.SelectOptions;
import io.tarantool.client.crud.options.TruncateOptions;
import io.tarantool.client.crud.options.UpdateOptions;
import io.tarantool.client.crud.options.UpsertManyOptions;
import io.tarantool.client.factory.TarantoolSpace;
import io.tarantool.client.operation.Operations;
import io.tarantool.core.protocol.IProtoRequestOpts;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.mapping.TarantoolJacksonMapping;
import io.tarantool.mapping.TarantoolJacksonMappingWithTargetTypeReference;
import io.tarantool.mapping.TarantoolResponse;
import io.tarantool.mapping.Tuple;
import io.tarantool.mapping.crud.CrudBatchResponse;
import io.tarantool.mapping.crud.CrudError;
import io.tarantool.mapping.crud.CrudScalarResponse;
import io.tarantool.pool.IProtoClientPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

final class TarantoolCrudSpaceImpl
extends TarantoolSpace
implements TarantoolCrudSpace {
    public static final String CRUD_INSERT = "crud.insert";
    public static final String CRUD_INSERT_OBJECT = "crud.insert_object";
    public static final String CRUD_INSERT_MANY = "crud.insert_many";
    public static final String CRUD_INSERT_MANY_OBJECT = "crud.insert_object_many";
    public static final String CRUD_REPLACE = "crud.replace";
    public static final String CRUD_REPLACE_OBJECT = "crud.replace_object";
    public static final String CRUD_REPLACE_MANY = "crud.replace_many";
    public static final String CRUD_REPLACE_OBJECT_MANY = "crud.replace_object_many";
    public static final String CRUD_GET = "crud.get";
    public static final String CRUD_SELECT = "crud.select";
    public static final String CRUD_DELETE = "crud.delete";
    public static final String CRUD_UPDATE = "crud.update";
    public static final String CRUD_UPSERT = "crud.upsert";
    public static final String CRUD_UPSERT_MANY = "crud.upsert_many";
    public static final String CRUD_UPSERT_OBJECT = "crud.upsert_object";
    public static final String CRUD_UPSERT_OBJECT_MANY = "crud.upsert_object_many";
    public static final String CRUD_TRUNCATE = "crud.truncate";
    public static final String CRUD_COUNT = "crud.count";
    public static final String CRUD_LEN = "crud.len";
    public static final String CRUD_MIN = "crud.min";
    public static final String CRUD_MAX = "crud.max";
    public static final TypeReference<CrudScalarResponse<Integer>> CRUD_CALL_INT_RESULT = new TypeReference<CrudScalarResponse<Integer>>(){};
    public static final TypeReference<CrudScalarResponse<Boolean>> CRUD_CALL_BOOL_RESULT = new TypeReference<CrudScalarResponse<Boolean>>(){};
    private static final InsertOptions DEFAULT_INSERT_OPTIONS = InsertOptions.builder().build();
    private static final InsertManyOptions DEFAULT_INSERT_MANY_OPTIONS = InsertManyOptions.builder().build();
    private static final UpsertManyOptions DEFAULT_UPSERT_MANY_OPTIONS = UpsertManyOptions.builder().build();
    private static final GetOptions DEFAULT_GET_OPTIONS = GetOptions.builder().build();
    private static final SelectOptions DEFAULT_SELECT_OPTIONS = SelectOptions.builder().build();
    private static final DeleteOptions DEFAULT_DELETE_OPTIONS = DeleteOptions.builder().build();
    private static final UpdateOptions DEFAULT_UPDATE_OPTIONS = UpdateOptions.builder().build();
    private static final TruncateOptions DEFAULT_TRUNCATE_OPTIONS = TruncateOptions.builder().build();
    private static final LenOptions DEFAULT_LEN_OPTIONS = LenOptions.builder().build();
    private static final CountOptions DEFAULT_COUNT_OPTIONS = CountOptions.builder().build();
    private static final MinMaxOptions DEFAULT_MIN_MAX_OPTIONS = MinMaxOptions.builder().build();
    private final TarantoolBalancer balancer;
    private final String spaceName;

    public TarantoolCrudSpaceImpl(TarantoolBalancer balancer, String spaceName) {
        this.balancer = balancer;
        this.spaceName = spaceName;
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> insert(Options options, TypeReference<T> entity, Object ... arguments) {
        return this.crudCallSingleResult(options, entity, CRUD_INSERT, arguments);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> insert(Object tuple) {
        return this.insert(tuple, DEFAULT_INSERT_OPTIONS);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> insertObject(Object tuple) {
        return this.insertObject(tuple, DEFAULT_INSERT_OPTIONS);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> insert(Object tuple, InsertOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_INSERT, this.toTupleOptsArgs(tuple, options));
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> insertObject(Object tuple, InsertOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_INSERT_OBJECT, this.toTupleOptsArgs(tuple, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> insert(Object tuple, Class<T> entity) {
        return this.insert(tuple, DEFAULT_INSERT_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> insert(Object tuple, InsertOptions options, Class<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_INSERT, this.toTupleOptsArgs(tuple, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> insert(Object tuple, TypeReference<T> entity) {
        return this.insert(tuple, DEFAULT_INSERT_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> insert(Object tuple, InsertOptions options, TypeReference<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_INSERT, this.toTupleOptsArgs(tuple, options));
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<CrudBatchResponse<T>>> insertMany(Options options, TypeReference<T> entity, Object ... arguments) {
        return this.crudBatchCall(CRUD_INSERT_MANY, options, entity, arguments);
    }

    @Override
    public CompletableFuture<CrudBatchResponse<List<Tuple<List<?>>>>> insertMany(List<?> tuples) {
        return this.insertMany(tuples, DEFAULT_INSERT_MANY_OPTIONS);
    }

    @Override
    public CompletableFuture<CrudBatchResponse<List<Tuple<List<?>>>>> insertObjectMany(List<?> tuples) {
        return this.insertObjectMany(tuples, DEFAULT_INSERT_MANY_OPTIONS);
    }

    @Override
    public CompletableFuture<CrudBatchResponse<List<Tuple<List<?>>>>> insertMany(List<?> tuples, InsertManyOptions options) {
        return this.crudBatchCall(CRUD_INSERT_MANY, (Options)options, this.toTuplesOptsArgs(tuples, (CrudOptions)options));
    }

    @Override
    public CompletableFuture<CrudBatchResponse<List<Tuple<List<?>>>>> insertObjectMany(List<?> tuples, InsertManyOptions options) {
        return this.crudBatchCall(CRUD_INSERT_MANY_OBJECT, (Options)options, this.toTuplesOptsArgs(tuples, (CrudOptions)options));
    }

    @Override
    public <T> CompletableFuture<CrudBatchResponse<List<Tuple<T>>>> insertMany(List<?> tuples, Class<T> entity) {
        return this.insertMany(tuples, DEFAULT_INSERT_MANY_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<CrudBatchResponse<List<Tuple<T>>>> insertMany(List<?> tuples, InsertManyOptions options, Class<T> entity) {
        return this.crudBatchCall(CRUD_INSERT_MANY, this.toTuplesOptsArgs(tuples, (CrudOptions)options), (Options)options, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<CrudBatchResponse<T>>> insertMany(List<?> tuples, TypeReference<T> entity) {
        return this.insertMany(tuples, DEFAULT_INSERT_MANY_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<CrudBatchResponse<T>>> insertMany(List<?> tuples, InsertManyOptions options, TypeReference<T> entity) {
        return this.crudBatchCall(CRUD_INSERT_MANY, this.toTuplesOptsArgs(tuples, (CrudOptions)options), (Options)options, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<CrudBatchResponse<T>>> replaceMany(Options options, TypeReference<T> entity, Object ... arguments) {
        return this.crudBatchCall(CRUD_REPLACE_MANY, options, entity, arguments);
    }

    @Override
    public CompletableFuture<CrudBatchResponse<List<Tuple<List<?>>>>> replaceMany(List<?> tuples) {
        return this.replaceMany(tuples, DEFAULT_INSERT_MANY_OPTIONS);
    }

    @Override
    public CompletableFuture<CrudBatchResponse<List<Tuple<List<?>>>>> replaceObjectMany(List<?> tuples) {
        return this.replaceObjectMany(tuples, DEFAULT_INSERT_MANY_OPTIONS);
    }

    @Override
    public CompletableFuture<CrudBatchResponse<List<Tuple<List<?>>>>> replaceMany(List<?> tuples, InsertManyOptions options) {
        return this.crudBatchCall(CRUD_REPLACE_MANY, (Options)options, this.toTuplesOptsArgs(tuples, (CrudOptions)options));
    }

    @Override
    public CompletableFuture<CrudBatchResponse<List<Tuple<List<?>>>>> replaceObjectMany(List<?> tuples, InsertManyOptions options) {
        return this.crudBatchCall(CRUD_REPLACE_OBJECT_MANY, (Options)options, this.toTuplesOptsArgs(tuples, (CrudOptions)options));
    }

    @Override
    public <T> CompletableFuture<CrudBatchResponse<List<Tuple<T>>>> replaceMany(List<?> tuples, Class<T> entity) {
        return this.replaceMany(tuples, DEFAULT_INSERT_MANY_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<CrudBatchResponse<List<Tuple<T>>>> replaceMany(List<?> tuples, InsertManyOptions options, Class<T> entity) {
        return this.crudBatchCall(CRUD_REPLACE_MANY, this.toTuplesOptsArgs(tuples, (CrudOptions)options), (Options)options, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<CrudBatchResponse<T>>> replaceMany(List<?> tuples, TypeReference<T> entity) {
        return this.replaceMany(tuples, DEFAULT_INSERT_MANY_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<CrudBatchResponse<T>>> replaceMany(List<?> tuples, InsertManyOptions options, TypeReference<T> entity) {
        return this.crudBatchCall(CRUD_REPLACE_MANY, this.toTuplesOptsArgs(tuples, (CrudOptions)options), (Options)options, entity);
    }

    @Override
    public CompletableFuture<List<CrudError>> upsertMany(Options options, Object ... arguments) {
        return this.crudBatchCall(CRUD_UPSERT_MANY, options, arguments).thenApply(CrudBatchResponse::getErrors);
    }

    @Override
    public CompletableFuture<List<CrudError>> upsertObjectMany(Options options, Object ... arguments) {
        return this.crudBatchCall(CRUD_UPSERT_OBJECT_MANY, options, arguments).thenApply(CrudBatchResponse::getErrors);
    }

    @Override
    public CompletableFuture<List<CrudError>> upsertMany(List<?> tuplesOperationData) {
        return this.upsertMany(tuplesOperationData, DEFAULT_UPSERT_MANY_OPTIONS);
    }

    @Override
    public CompletableFuture<List<CrudError>> upsertObjectMany(List<?> tuplesOperationData) {
        return this.upsertObjectMany(tuplesOperationData, DEFAULT_UPSERT_MANY_OPTIONS);
    }

    @Override
    public CompletableFuture<List<CrudError>> upsertMany(UpsertBatch batch) {
        return this.upsertMany(batch, DEFAULT_UPSERT_MANY_OPTIONS);
    }

    @Override
    public CompletableFuture<List<CrudError>> upsertObjectMany(UpsertBatch batch) {
        return this.upsertObjectMany(batch, DEFAULT_UPSERT_MANY_OPTIONS);
    }

    @Override
    public CompletableFuture<List<CrudError>> upsertMany(List<?> tuplesOperationData, UpsertManyOptions options) {
        return this.crudBatchCall(CRUD_UPSERT_MANY, (Options)options, this.toTuplesOptsArgs(tuplesOperationData, (CrudOptions)options)).thenApply(CrudBatchResponse::getErrors);
    }

    @Override
    public CompletableFuture<List<CrudError>> upsertObjectMany(List<?> tuplesOperationData, UpsertManyOptions options) {
        return this.crudBatchCall(CRUD_UPSERT_OBJECT_MANY, (Options)options, this.toTuplesOptsArgs(tuplesOperationData, (CrudOptions)options)).thenApply(CrudBatchResponse::getErrors);
    }

    @Override
    public CompletableFuture<List<CrudError>> upsertMany(UpsertBatch batch, UpsertManyOptions options) {
        return this.crudBatchCall(CRUD_UPSERT_MANY, (Options)options, this.toTuplesOptsArgs(batch, (CrudOptions)options)).thenApply(CrudBatchResponse::getErrors);
    }

    @Override
    public CompletableFuture<List<CrudError>> upsertObjectMany(UpsertBatch batch, UpsertManyOptions options) {
        return this.crudBatchCall(CRUD_UPSERT_OBJECT_MANY, (Options)options, this.toTuplesOptsArgs(batch, (CrudOptions)options)).thenApply(CrudBatchResponse::getErrors);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> replace(Options options, TypeReference<T> entity, Object ... arguments) {
        return this.crudCallSingleResult(options, entity, CRUD_REPLACE, arguments);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> replace(Object tuple) {
        return this.replace(tuple, DEFAULT_INSERT_OPTIONS);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> replaceObject(Object tuple) {
        return this.replaceObject(tuple, DEFAULT_INSERT_OPTIONS);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> replace(Object tuple, InsertOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_REPLACE, this.toTupleOptsArgs(tuple, options));
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> replaceObject(Object tuple, InsertOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_REPLACE_OBJECT, this.toTupleOptsArgs(tuple, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> replace(Object tuple, Class<T> entity) {
        return this.replace(tuple, DEFAULT_INSERT_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> replace(Object tuple, InsertOptions options, Class<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_REPLACE, this.toTupleOptsArgs(tuple, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> replace(Object tuple, TypeReference<T> entity) {
        return this.replace(tuple, DEFAULT_INSERT_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> replace(Object tuple, InsertOptions options, TypeReference<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_REPLACE, this.toTupleOptsArgs(tuple, options));
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<T>> select(Options options, TypeReference<T> entity, Object ... arguments) {
        return this.crudCallSelectResult(options, entity, this.withSpaceName(arguments));
    }

    @Override
    public CompletableFuture<List<Tuple<List<?>>>> select(List<Condition> conditions) {
        return this.select(conditions, DEFAULT_SELECT_OPTIONS);
    }

    @Override
    public CompletableFuture<List<Tuple<List<?>>>> select(Condition ... conditions) {
        return this.select(Arrays.asList(conditions), DEFAULT_SELECT_OPTIONS);
    }

    @Override
    public CompletableFuture<List<Tuple<List<?>>>> select(List<Condition> conditions, SelectOptions options) {
        return this.crudCallSelectResult(options, this.toSelectArgs(conditions, options));
    }

    @Override
    public <T> CompletableFuture<List<Tuple<T>>> select(List<Condition> conditions, Class<T> entity) {
        return this.select(conditions, DEFAULT_SELECT_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<List<Tuple<T>>> select(List<Condition> conditions, SelectOptions options, Class<T> entity) {
        return this.crudCallSelectResult((Options)options, entity, this.toSelectArgs(conditions, options));
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<T>> select(List<Condition> conditions, TypeReference<T> entity) {
        return this.select(conditions, DEFAULT_SELECT_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<T>> select(List<Condition> conditions, SelectOptions options, TypeReference<T> entity) {
        return this.crudCallSelectResult((Options)options, entity, this.toSelectArgs(conditions, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> get(Options options, TypeReference<T> entity, Object ... arguments) {
        return this.crudCallSingleResult(options, entity, CRUD_GET, arguments);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> get(Object key) {
        return this.get(key, DEFAULT_GET_OPTIONS);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> get(Object key, GetOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_GET, this.toKeyOptsArgs(key, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> get(Object key, Class<T> entity) {
        return this.get(key, DEFAULT_GET_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> get(Object key, GetOptions options, Class<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_GET, this.toKeyOptsArgs(key, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> get(Object key, TypeReference<T> entity) {
        return this.get(key, DEFAULT_GET_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> get(Object key, GetOptions options, TypeReference<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_GET, this.toKeyOptsArgs(key, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> delete(Options options, TypeReference<T> entity, Object ... arguments) {
        return this.crudCallSingleResult(options, entity, CRUD_DELETE, arguments);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> delete(Object key) {
        return this.delete(key, DEFAULT_DELETE_OPTIONS);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> delete(Object key, DeleteOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_DELETE, this.toKeyOptsArgs(key, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> delete(Object key, Class<T> entity) {
        return this.delete(key, DEFAULT_DELETE_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> delete(Object key, DeleteOptions options, Class<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_DELETE, this.toKeyOptsArgs(key, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> delete(Object key, TypeReference<T> entity) {
        return this.delete(key, DEFAULT_DELETE_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> delete(Object key, DeleteOptions options, TypeReference<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_DELETE, this.toKeyOptsArgs(key, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> min(Options options, TypeReference<T> entity, Object ... arguments) {
        return this.crudCallSingleResult(options, entity, CRUD_MIN, arguments);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> min(String indexName) {
        return this.min(indexName, DEFAULT_MIN_MAX_OPTIONS);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> min(String indexName, MinMaxOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_MIN, this.toIndexNameOptsArgs(indexName, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> min(String indexName, Class<T> entity) {
        return this.min(indexName, DEFAULT_MIN_MAX_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> min(String indexName, MinMaxOptions options, Class<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_MIN, this.toIndexNameOptsArgs(indexName, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> min(String indexName, TypeReference<T> entity) {
        return this.min(indexName, DEFAULT_MIN_MAX_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> min(String indexName, MinMaxOptions options, TypeReference<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_MIN, this.toIndexNameOptsArgs(indexName, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> max(Options options, TypeReference<T> entity, Object ... arguments) {
        return this.crudCallSingleResult(options, entity, CRUD_MAX, arguments);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> max(String indexName) {
        return this.max(indexName, DEFAULT_MIN_MAX_OPTIONS);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> max(String indexName, MinMaxOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_MAX, this.toIndexNameOptsArgs(indexName, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> max(String indexName, Class<T> entity) {
        return this.max(indexName, DEFAULT_MIN_MAX_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> max(String indexName, MinMaxOptions options, Class<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_MAX, this.toIndexNameOptsArgs(indexName, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> max(String indexName, TypeReference<T> entity) {
        return this.max(indexName, DEFAULT_MIN_MAX_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> max(String indexName, MinMaxOptions options, TypeReference<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_MAX, this.toIndexNameOptsArgs(indexName, options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(Options options, TypeReference<T> entity, Object ... arguments) {
        return this.crudCallSingleResult(options, entity, CRUD_UPDATE, arguments);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> update(Object key, List<List<?>> operations) {
        return this.update(key, operations, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> update(Object key, Operations operations) {
        return this.update(key, operations, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> update(Object key, List<List<?>> operations, UpdateOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_UPDATE, this.toKeyOperationsOptsArgs(key, operations, (CrudOptions)options));
    }

    @Override
    public CompletableFuture<Tuple<List<?>>> update(Object key, Operations operations, UpdateOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_UPDATE, this.toKeyOperationsOptsArgs(key, operations, (CrudOptions)options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(Object key, List<List<?>> operations, Class<T> entity) {
        return this.update(key, operations, DEFAULT_UPDATE_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(Object key, Operations operations, Class<T> entity) {
        return this.update(key, operations, DEFAULT_UPDATE_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(Object key, List<List<?>> operations, UpdateOptions options, Class<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_UPDATE, this.toKeyOperationsOptsArgs(key, operations, (CrudOptions)options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(Object key, Operations operations, UpdateOptions options, Class<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_UPDATE, this.toKeyOperationsOptsArgs(key, operations, (CrudOptions)options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(Object key, List<List<?>> operations, TypeReference<T> entity) {
        return this.update(key, operations, DEFAULT_UPDATE_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(Object key, Operations operations, TypeReference<T> entity) {
        return this.update(key, operations, DEFAULT_UPDATE_OPTIONS, entity);
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(Object key, List<List<?>> operations, UpdateOptions options, TypeReference<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_UPDATE, this.toKeyOperationsOptsArgs(key, operations, (CrudOptions)options));
    }

    @Override
    public <T> CompletableFuture<Tuple<T>> update(Object key, Operations operations, UpdateOptions options, TypeReference<T> entity) {
        return this.crudCallSingleResult((Options)options, entity, CRUD_UPDATE, this.toKeyOperationsOptsArgs(key, operations, (CrudOptions)options));
    }

    @Override
    public CompletableFuture<Void> upsert(Options options, Object ... arguments) {
        return this.crudCallSingleResult(options, CRUD_UPSERT, arguments).thenAccept(r -> {});
    }

    @Override
    public CompletableFuture<Void> upsertObject(Options options, Object ... arguments) {
        return this.crudCallSingleResult(options, CRUD_UPSERT_OBJECT, arguments).thenAccept(r -> {});
    }

    @Override
    public CompletableFuture<Void> upsert(Object tuple, List<List<?>> operations) {
        return this.upsert(tuple, operations, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public CompletableFuture<Void> upsertObject(Object tuple, List<List<?>> operations) {
        return this.upsertObject(tuple, operations, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public CompletableFuture<Void> upsert(Object tuple, Operations operations) {
        return this.upsert(tuple, operations, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public CompletableFuture<Void> upsertObject(Object tuple, Operations operations) {
        return this.upsertObject(tuple, operations, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public CompletableFuture<Void> upsert(Object tuple, List<List<?>> operations, UpdateOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_UPSERT, this.toTupleOperationsOptsArgs(tuple, operations, options)).thenAccept(r -> {});
    }

    @Override
    public CompletableFuture<Void> upsertObject(Object tuple, List<List<?>> operations, UpdateOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_UPSERT_OBJECT, this.toTupleOperationsOptsArgs(tuple, operations, options)).thenAccept(r -> {});
    }

    @Override
    public CompletableFuture<Void> upsert(Object tuple, Operations operations, UpdateOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_UPSERT, this.toTupleOperationsOptsArgs(tuple, operations, options)).thenAccept(r -> {});
    }

    @Override
    public CompletableFuture<Void> upsertObject(Object tuple, Operations operations, UpdateOptions options) {
        return this.crudCallSingleResult((Options)options, CRUD_UPSERT_OBJECT, this.toTupleOperationsOptsArgs(tuple, operations, options)).thenAccept(r -> {});
    }

    @Override
    public CompletableFuture<Boolean> truncate(Options options, Object ... arguments) {
        return this.mapTruncateResult(this.iprotoCall(options, CRUD_TRUNCATE, this.withSpaceName(arguments)));
    }

    @Override
    public CompletableFuture<Boolean> truncate() {
        return this.truncate(DEFAULT_TRUNCATE_OPTIONS);
    }

    @Override
    public CompletableFuture<Boolean> truncate(TruncateOptions options) {
        return this.mapTruncateResult(this.iprotoCall(options, CRUD_TRUNCATE, this.toOptsArgs(options)));
    }

    @Override
    public CompletableFuture<Integer> len(Options options, Object ... arguments) {
        return this.mapCountLenResult(this.iprotoCall(options, CRUD_LEN, this.withSpaceName(arguments)));
    }

    @Override
    public CompletableFuture<Integer> len() {
        return this.len(DEFAULT_LEN_OPTIONS);
    }

    @Override
    public CompletableFuture<Integer> len(LenOptions options) {
        return this.mapCountLenResult(this.iprotoCall(options, CRUD_LEN, this.toOptsArgs(options)));
    }

    @Override
    public CompletableFuture<Integer> count(Options options, Object ... arguments) {
        return this.mapCountLenResult(this.iprotoCall(options, CRUD_COUNT, this.withSpaceName(arguments)));
    }

    @Override
    public CompletableFuture<Integer> count(Condition ... conditions) {
        return this.count(Arrays.asList(conditions));
    }

    @Override
    public CompletableFuture<Integer> count(List<Condition> conditions) {
        return this.count(conditions, DEFAULT_COUNT_OPTIONS);
    }

    @Override
    public CompletableFuture<Integer> count(List<Condition> conditions, CountOptions options) {
        return this.mapCountLenResult(this.iprotoCall(options, CRUD_COUNT, this.toSelectArgs(conditions, options)));
    }

    private CompletableFuture<Integer> mapCountLenResult(CompletableFuture<IProtoResponse> responseFuture) {
        return TarantoolJacksonMapping.convertFutureResult(responseFuture, CRUD_CALL_INT_RESULT).thenApply(response -> (Integer)((CrudScalarResponse)response.get()).getValue());
    }

    private List<Object> toOptsArgs(CrudOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        return Arrays.asList(this.spaceName, options.getOptions());
    }

    private CompletableFuture<Boolean> mapTruncateResult(CompletableFuture<IProtoResponse> responseFuture) {
        return TarantoolJacksonMapping.convertFutureResult(responseFuture, CRUD_CALL_BOOL_RESULT).thenApply(response -> (Boolean)((CrudScalarResponse)response.get()).getValue());
    }

    private List<Object> toTupleOperationsOptsArgs(Object tuple, List<?> operations, CrudOptions options) {
        if (tuple == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        if (operations == null) {
            throw new IllegalArgumentException("operations can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        return Arrays.asList(this.spaceName, tuple, operations, options.getOptions());
    }

    private List<Object> toKeyOperationsOptsArgs(Object key, List<List<?>> operations, CrudOptions options) {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        if (operations == null) {
            throw new IllegalArgumentException("operations can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        return Arrays.asList(this.spaceName, key, operations, options.getOptions());
    }

    private List<Object> toKeyOperationsOptsArgs(Object key, Operations operations, CrudOptions options) {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        if (operations == null) {
            throw new IllegalArgumentException("operations can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        return Arrays.asList(this.spaceName, key, operations, options.getOptions());
    }

    private List<Object> toIndexNameOptsArgs(String indexName, CrudOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        return Arrays.asList(this.spaceName, indexName, options.getOptions());
    }

    private List<Object> toKeyOptsArgs(Object key, CrudOptions options) {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        return Arrays.asList(this.spaceName, key, options.getOptions());
    }

    private List<Object> toSelectArgs(List<Condition> conditions, CrudOptions options) {
        if (conditions == null) {
            throw new IllegalArgumentException("conditions can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        return Arrays.asList(this.spaceName, conditions, options.getOptions());
    }

    private List<Object> toTuplesOptsArgs(List<?> tuples, CrudOptions options) {
        if (tuples == null) {
            throw new IllegalArgumentException("tuples can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        return Arrays.asList(this.spaceName, tuples, options.getOptions());
    }

    private List<Object> toTuplesOptsArgs(UpsertBatch tuples, CrudOptions options) {
        if (tuples == null) {
            throw new IllegalArgumentException("tuples can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        return Arrays.asList(this.spaceName, tuples, options.getOptions());
    }

    private <T> CompletableFuture<TarantoolResponse<CrudBatchResponse<T>>> crudBatchCall(String functionName, Options options, TypeReference<T> entity, Object ... args) {
        return this.crudBatchCall(functionName, this.withSpaceName(args), options, entity);
    }

    private <T> CompletableFuture<TarantoolResponse<CrudBatchResponse<T>>> crudBatchCall(String functionName, List<Object> args, Options options, TypeReference<T> entity) {
        return TarantoolJacksonMapping.convertFutureResult(this.iprotoCall(options, functionName, args), (JavaType)this.wrapIntoType(CrudBatchResponse.class, entity));
    }

    private <T> CompletableFuture<CrudBatchResponse<List<Tuple<T>>>> crudBatchCall(String functionName, List<Object> args, Options options, Class<T> entity) {
        return TarantoolJacksonMapping.convertCrudBatchResultFuture(this.iprotoCall(options, functionName, args), entity);
    }

    private CompletableFuture<CrudBatchResponse<List<Tuple<List<?>>>>> crudBatchCall(String functionName, Options options, Object ... args) {
        return this.crudBatchCall(functionName, options, this.withSpaceName(args));
    }

    private CompletableFuture<CrudBatchResponse<List<Tuple<List<?>>>>> crudBatchCall(String functionName, Options options, List<Object> args) {
        return TarantoolJacksonMapping.convertCrudBatchResultFuture(this.iprotoCall(options, functionName, args));
    }

    private List<Object> toTupleOptsArgs(Object tuple, CrudOptions options) {
        if (tuple == null) {
            throw new IllegalArgumentException("tuple can't be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        return Arrays.asList(this.spaceName, tuple, options.getOptions());
    }

    private <T> CompletableFuture<TarantoolResponse<T>> crudCallSelectResult(Options options, TypeReference<T> entity, List<Object> args) {
        return TarantoolJacksonMappingWithTargetTypeReference.convertCrudSelectResultFuture(this.iprotoCall(options, CRUD_SELECT, args), entity);
    }

    private <T> CompletableFuture<Tuple<T>> crudCallSingleResult(Options options, TypeReference<T> entity, String functionName, Object ... args) {
        return this.crudCallSingleResult(options, entity, functionName, this.withSpaceName(args));
    }

    private <T> CompletableFuture<Tuple<T>> crudCallSingleResult(Options options, TypeReference<T> entity, String functionName, List<Object> args) {
        return TarantoolJacksonMapping.convertCrudSingleResultFuture(this.iprotoCall(options, functionName, args), entity);
    }

    private <T> CompletableFuture<List<Tuple<T>>> crudCallSelectResult(Options options, Class<T> entity, List<Object> args) {
        return TarantoolJacksonMappingWithTargetTypeReference.convertCrudSelectResultFuture(this.iprotoCall(options, CRUD_SELECT, args), entity);
    }

    private <T> CompletableFuture<Tuple<T>> crudCallSingleResult(Options options, Class<T> entity, String functionName, List<Object> args) {
        return TarantoolJacksonMapping.convertCrudSingleResultFuture(this.iprotoCall(options, functionName, args), entity);
    }

    private CompletableFuture<List<Tuple<List<?>>>> crudCallSelectResult(Options options, List<Object> args) {
        return TarantoolJacksonMappingWithTargetTypeReference.convertCrudSelectResultFuture(this.iprotoCall(options, CRUD_SELECT, args));
    }

    private CompletableFuture<Tuple<List<?>>> crudCallSingleResult(Options options, String functionName, Object ... args) {
        return this.crudCallSingleResult(options, functionName, this.withSpaceName(args));
    }

    private CompletableFuture<Tuple<List<?>>> crudCallSingleResult(Options options, String functionName, List<Object> args) {
        return TarantoolJacksonMapping.convertCrudSingleResultFuture(this.iprotoCall(options, functionName, args));
    }

    private List<Object> withSpaceName(Object[] arguments) {
        ArrayList<Object> args = new ArrayList<Object>(Arrays.asList(arguments));
        args.add(0, this.spaceName);
        return args;
    }

    private CompletableFuture<IProtoResponse> iprotoCall(Options options, String functionName, List<Object> args) {
        if (options == null) {
            throw new IllegalArgumentException("options can't be null");
        }
        return this.balancer.getNext().thenCompose(c -> c.call(functionName, TarantoolJacksonMapping.toValue((Object)args), null, IProtoRequestOpts.empty().withRequestTimeout(options.getTimeout()).withStreamId(options.getStreamId())));
    }

    @Override
    public TarantoolBalancer getBalancer() {
        return this.balancer;
    }

    @Override
    public IProtoClientPool getPool() {
        return this.balancer.getPool();
    }
}

