/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.factory;

import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.tarantool.balancer.TarantoolBalancer;
import io.tarantool.client.TarantoolClient;
import io.tarantool.client.box.TarantoolBoxClient;
import io.tarantool.client.factory.TarantoolBoxClientImpl;
import io.tarantool.core.WatcherOptions;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.pool.HeartbeatOpts;
import io.tarantool.pool.InstanceConnectionGroup;
import io.tarantool.pool.TripleConsumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TarantoolBoxClientBuilder {
    private final Map<ChannelOption<?>, Object> options = new HashMap(TarantoolClient.DEFAULT_NETTY_CHANNEL_OPTIONS);
    private String host = "localhost";
    private int port = 3301;
    private String user = "guest";
    private String password = null;
    private List<InstanceConnectionGroup> groups;
    private int nThreads = 0;
    private Timer timerService = new HashedWheelTimer();
    private boolean fetchSchema = true;
    private boolean ignoreOldSchemaVersion = true;
    private boolean gracefulShutdown = true;
    private Class<? extends TarantoolBalancer> balancerClass = TarantoolBalancer.DEFAULT_BALANCER_CLASS;
    private HeartbeatOpts heartbeatOpts = null;
    private WatcherOptions watcherOpts = null;
    private long connectTimeout = 3000L;
    private long reconnectAfter = 1000L;
    private MeterRegistry metricsRegistry;
    private TripleConsumer<String, Integer, IProtoResponse> ignoredPacketsHandler;
    private SslContext sslContext;

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.options;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public List<InstanceConnectionGroup> getGroups() {
        return this.groups;
    }

    public int getnThreads() {
        return this.nThreads;
    }

    public Timer getTimerService() {
        return this.timerService;
    }

    public boolean isFetchSchema() {
        return this.fetchSchema;
    }

    public boolean isIgnoreOldSchemaVersion() {
        return this.ignoreOldSchemaVersion;
    }

    public boolean isGracefulShutdown() {
        return this.gracefulShutdown;
    }

    public Class<? extends TarantoolBalancer> getBalancerClass() {
        return this.balancerClass;
    }

    public HeartbeatOpts getHeartbeatOpts() {
        return this.heartbeatOpts;
    }

    public WatcherOptions getWatcherOpts() {
        return this.watcherOpts;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getReconnectAfter() {
        return this.reconnectAfter;
    }

    public MeterRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public TripleConsumer<String, Integer, IProtoResponse> getIgnoredPacketsHandler() {
        return this.ignoredPacketsHandler;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public TarantoolBoxClientBuilder withGroups(List<InstanceConnectionGroup> groups) {
        this.groups = groups;
        return this;
    }

    public TarantoolBoxClientBuilder withHost(String host) {
        if (host == null) {
            throw new IllegalArgumentException("Host can't be null");
        }
        this.host = host;
        return this;
    }

    public TarantoolBoxClientBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public TarantoolBoxClientBuilder withUser(String user) {
        this.user = user;
        return this;
    }

    public TarantoolBoxClientBuilder withPassword(String password) {
        this.password = password;
        return this;
    }

    public <T> TarantoolBoxClientBuilder withChannelOption(ChannelOption<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("ChannelOption key can't be null");
        }
        this.options.put(key, value);
        return this;
    }

    public TarantoolBoxClientBuilder withChannelOptions(Map<ChannelOption<?>, Object> channelOptions) {
        this.options.putAll(channelOptions);
        return this;
    }

    public TarantoolBoxClientBuilder withEventLoopThreadsCount(int nThreads) {
        this.nThreads = nThreads;
        return this;
    }

    public TarantoolBoxClientBuilder withTimerService(Timer timerService) {
        if (timerService == null) {
            throw new IllegalArgumentException("Timer can't be null");
        }
        this.timerService = timerService;
        return this;
    }

    public TarantoolBoxClientBuilder withFetchSchema(boolean fetchSchema) {
        this.fetchSchema = fetchSchema;
        return this;
    }

    public TarantoolBoxClientBuilder enableOldSchemaVersionCheck() {
        this.ignoreOldSchemaVersion = false;
        return this;
    }

    public TarantoolBoxClientBuilder disableGracefulShutdown() {
        this.gracefulShutdown = false;
        return this;
    }

    public TarantoolBoxClientBuilder withBalancerClass(Class<? extends TarantoolBalancer> balancerClass) {
        if (balancerClass == null) {
            throw new IllegalArgumentException("BalancerClass key can't be null");
        }
        this.balancerClass = balancerClass;
        return this;
    }

    public TarantoolBoxClientBuilder withHeartbeat(HeartbeatOpts opts) {
        this.heartbeatOpts = opts;
        return this;
    }

    public TarantoolBoxClientBuilder withWatcherOptions(WatcherOptions opts) {
        this.watcherOpts = opts;
        return this;
    }

    public TarantoolBoxClientBuilder withConnectTimeout(long timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public TarantoolBoxClientBuilder withReconnectAfter(long after) {
        this.reconnectAfter = after;
        return this;
    }

    public TarantoolBoxClientBuilder withMeterRegistry(MeterRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        return this;
    }

    public TarantoolBoxClientBuilder withIgnoredPacketsHandler(TripleConsumer<String, Integer, IProtoResponse> handler) {
        this.ignoredPacketsHandler = handler;
        return this;
    }

    public TarantoolBoxClientBuilder withSslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public TarantoolBoxClient build() throws Exception {
        if (this.groups == null) {
            this.groups = Collections.singletonList(InstanceConnectionGroup.builder().withHost(this.host).withPort(this.port).withSize(1).withTag("default").withUser(this.user).withPassword(this.password).build());
        }
        return new TarantoolBoxClientImpl(this.groups, this.options, this.nThreads, this.timerService, this.fetchSchema, this.ignoreOldSchemaVersion, this.gracefulShutdown, this.balancerClass, this.heartbeatOpts, this.watcherOpts, this.connectTimeout, this.reconnectAfter, this.metricsRegistry, this.ignoredPacketsHandler, this.sslContext);
    }
}

