/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.crud.options;

import io.tarantool.client.crud.options.CrudOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpsertManyOptions
implements CrudOptions {
    private static final String TIMEOUT = "timeout";
    private static final String FIELDS = "fields";
    private static final String STOP_ON_ERROR = "stop_on_error";
    private static final String ROLLBACK_ON_ERROR = "rollback_on_error";
    private static final String VSHARD_ROUTER = "vshard_router";
    private static final String NO_RETURN = "noreturn";
    private static final String FETCH_LATEST_METADATA = "fetch_latest_metadata";
    public static final long DEFAULT_TIMEOUT = 5000L;
    private final Long timeout;
    private final Long streamId;
    private final Map<String, Object> crudOptions;

    public UpsertManyOptions(Long timeout, Long streamId, Map<String, Object> options) {
        this.crudOptions = options;
        this.timeout = timeout;
        this.streamId = streamId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public Long getStreamId() {
        return this.streamId;
    }

    @Override
    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.crudOptions);
    }

    public static class Builder {
        private final Map<String, Object> options = new HashMap<String, Object>();
        private long timeout = 5000L;
        private Long streamId;

        public Builder withTimeout(long timeout) {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout should be greater than 0");
            }
            this.timeout = timeout;
            return this;
        }

        public Builder withStreamId(long streamId) {
            if (streamId < 0L) {
                throw new IllegalArgumentException("streamId should be greater or equal 0");
            }
            this.streamId = streamId;
            return this;
        }

        public Builder withCrudTimeout(long timeout) {
            this.addOption(UpsertManyOptions.TIMEOUT, timeout);
            return this;
        }

        private void addOption(String name, Object value) {
            if (name != null) {
                this.options.put(name, value);
            }
        }

        public Builder withFields(String ... fields) {
            this.addOption(UpsertManyOptions.FIELDS, Arrays.asList(fields));
            return this;
        }

        public Builder withFields(List<String> fields) {
            this.addOption(UpsertManyOptions.FIELDS, fields);
            return this;
        }

        public Builder withVshardRouter(String vshardRouter) {
            this.addOption(UpsertManyOptions.VSHARD_ROUTER, vshardRouter);
            return this;
        }

        public Builder withNoReturn() {
            this.addOption(UpsertManyOptions.NO_RETURN, true);
            return this;
        }

        public Builder fetchLatestMetadata() {
            this.addOption(UpsertManyOptions.FETCH_LATEST_METADATA, true);
            return this;
        }

        public Builder stopOnError() {
            this.addOption(UpsertManyOptions.STOP_ON_ERROR, true);
            return this;
        }

        public Builder rollbackOnError() {
            this.addOption(UpsertManyOptions.ROLLBACK_ON_ERROR, true);
            return this;
        }

        public Builder withOption(String optionName, Object optionValue) {
            this.addOption(optionName, optionValue);
            return this;
        }

        public UpsertManyOptions build() {
            return new UpsertManyOptions(this.timeout, this.streamId, this.options);
        }
    }
}

