/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.crud.options;

import io.tarantool.client.crud.options.CrudOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeleteOptions
implements CrudOptions {
    private static final String TIMEOUT = "timeout";
    private static final String BUCKET_ID = "bucket_id";
    private static final String FIELDS = "fields";
    private static final String VSHARD_ROUTER = "vshard_router";
    private static final String NO_RETURN = "noreturn";
    private static final String FETCH_LATEST_METADATA = "fetch_latest_metadata";
    public static final long DEFAULT_TIMEOUT = 5000L;
    private final Long timeout;
    private final Long streamId;
    private final Map<String, Object> crudOptions;

    public DeleteOptions(Long timeout, Long streamId, Map<String, Object> options) {
        this.crudOptions = options;
        this.timeout = timeout;
        this.streamId = streamId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public Long getStreamId() {
        return this.streamId;
    }

    @Override
    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.crudOptions);
    }

    public static class Builder {
        private final Map<String, Object> options = new HashMap<String, Object>();
        private long timeout = 5000L;
        private Long streamId;

        public Builder withTimeout(long timeout) {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout should be greater than 0");
            }
            this.timeout = timeout;
            return this;
        }

        public Builder withStreamId(Long streamId) {
            if (streamId < 0L) {
                throw new IllegalArgumentException("streamId should be greater or equal 0");
            }
            this.streamId = streamId;
            return this;
        }

        public Builder withCrudTimeout(long timeout) {
            this.addOption(DeleteOptions.TIMEOUT, timeout);
            return this;
        }

        private void addOption(String name, Object value) {
            if (name != null) {
                this.options.put(name, value);
            }
        }

        public Builder withBucketId(Integer bucketId) {
            if (bucketId <= 0) {
                throw new IllegalArgumentException("bucketId should be greater 0");
            }
            this.addOption(DeleteOptions.BUCKET_ID, bucketId);
            return this;
        }

        public Builder withFields(String ... fields) {
            this.addOption(DeleteOptions.FIELDS, Arrays.asList(fields));
            return this;
        }

        public Builder withFields(List<String> fields) {
            this.addOption(DeleteOptions.FIELDS, fields);
            return this;
        }

        public Builder withNoReturn() {
            this.addOption(DeleteOptions.NO_RETURN, true);
            return this;
        }

        public Builder withVshardRouter(String vshardRouter) {
            this.addOption(DeleteOptions.VSHARD_ROUTER, vshardRouter);
            return this;
        }

        public Builder fetchLatestMetadata() {
            this.addOption(DeleteOptions.FETCH_LATEST_METADATA, true);
            return this;
        }

        public Builder withOption(String optionName, Object optionValue) {
            this.addOption(optionName, optionValue);
            return this;
        }

        public DeleteOptions build() {
            return new DeleteOptions(this.timeout, this.streamId, this.options);
        }
    }
}

