/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client;

import io.tarantool.client.Options;

public class BaseOptions
implements Options {
    public static final long DEFAULT_TIMEOUT = 5000L;
    private final long timeout;
    private final Long streamId;

    protected BaseOptions(long timeout, Long streamId) {
        this.timeout = timeout;
        this.streamId = streamId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public Long getStreamId() {
        return this.streamId;
    }

    public static class Builder {
        private long timeout = 5000L;
        private Long streamId;

        public Builder withTimeout(long timeout) {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout should be greater than 0");
            }
            this.timeout = timeout;
            return this;
        }

        public Builder withStreamId(long streamId) {
            if (streamId < 0L) {
                throw new IllegalArgumentException("streamId should be greater or equal 0");
            }
            this.streamId = streamId;
            return this;
        }

        public BaseOptions build() {
            return new BaseOptions(this.timeout, this.streamId);
        }
    }
}

