/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoUpdate
extends IProtoBaseRequest {
    private final Integer spaceId;
    private final String spaceName;
    private final Integer indexId;
    private final String indexName;
    private ArrayValue key;
    private ArrayValue operations;
    private byte[] rawKey;
    private byte[] rawOperations;

    public IProtoUpdate(Integer spaceId, String spaceName, Integer indexId, String indexName, ArrayValue key, ArrayValue operations, Long streamId) {
        this.spaceId = spaceId;
        this.indexId = indexId;
        this.spaceName = spaceName;
        this.indexName = indexName;
        this.key = key;
        this.operations = operations;
        this.setStreamId(streamId);
    }

    public IProtoUpdate(Integer spaceId, String spaceName, Integer indexId, String indexName, byte[] key, byte[] operations, Long streamId) {
        this.spaceId = spaceId;
        this.indexId = indexId;
        this.spaceName = spaceName;
        this.indexName = indexName;
        this.rawKey = key;
        this.rawOperations = operations;
        this.setStreamId(streamId);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_UPDATE;
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_FOUR_ITEMS);
        if (this.spaceId != null) {
            packer.addPayload(IProtoConstant.RAW_IPROTO_SPACE_ID);
            packer.packInt(this.spaceId.intValue());
        } else {
            packer.addPayload(IProtoConstant.RAW_IPROTO_SPACE_NAME);
            packer.packString(this.spaceName);
        }
        if (this.indexId != null) {
            packer.addPayload(IProtoConstant.RAW_IPROTO_INDEX_ID);
            packer.packInt(this.indexId.intValue());
        } else {
            packer.addPayload(IProtoConstant.RAW_IPROTO_INDEX_NAME);
            packer.packString(this.indexName);
        }
        packer.addPayload(IProtoConstant.RAW_IPROTO_KEY);
        this.packValue(packer, this.rawKey, (Value)this.key);
        packer.addPayload(IProtoConstant.RAW_IPROTO_TUPLE);
        this.packValue(packer, this.rawOperations, (Value)this.operations);
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() throws Exception {
        HashMap<Value, Object> map = new HashMap<Value, Object>();
        map.put(IProtoConstant.MP_IPROTO_SPACE_ID, ValueFactory.newInteger((int)this.spaceId));
        map.put(IProtoConstant.MP_IPROTO_SPACE_NAME, ValueFactory.newString((String)this.spaceName));
        map.put(IProtoConstant.MP_IPROTO_INDEX_ID, ValueFactory.newInteger((int)this.indexId));
        map.put(IProtoConstant.MP_IPROTO_INDEX_NAME, ValueFactory.newString((String)this.indexName));
        map.put(IProtoConstant.MP_IPROTO_KEY, this.key);
        map.put(IProtoConstant.MP_IPROTO_TUPLE, this.operations);
        return ValueFactory.newMap(map);
    }

    @Override
    public int getRequestType() {
        return 4;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoUpdate(syncId = ").append(this.getSyncId()).append(", spaceId = ").append(this.spaceId).append(", indexId = ").append(this.indexId).append(", spaceName = ").append(this.spaceName).append(", indexName = ").append(this.indexName).append(", key = ").append(this.key != null ? this.key : Arrays.toString(this.rawKey)).append(", operations = ").append(this.operations != null ? this.operations : Arrays.toString(this.rawOperations)).append(")");
        }
        return this.stringBuilder.toString();
    }
}

