/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ImmutableStringValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoPrepare
extends IProtoBaseRequest {
    private final String statementText;

    public IProtoPrepare(String statementText, Long streamId) {
        this.setStreamId(streamId);
        this.statementText = statementText;
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_ONE_ITEM);
        packer.addPayload(IProtoConstant.RAW_IPROTO_SQL_TEXT);
        packer.packString(this.statementText);
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() {
        HashMap<Value, ImmutableStringValue> map = new HashMap<Value, ImmutableStringValue>();
        map.put(IProtoConstant.MP_IPROTO_SQL_TEXT, ValueFactory.newString((String)this.statementText));
        return ValueFactory.newMap(map);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_PREPARE;
    }

    @Override
    public int getRequestType() {
        return 13;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoPrepare(syncId = ").append(this.getSyncId()).append(", statementText = ").append(this.statementText).append(")");
        }
        return this.stringBuilder.toString();
    }
}

