/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoId
extends IProtoBaseRequest {
    private final int protocolVersion;
    private final List<Integer> features;

    public IProtoId(int protocolVersion, List<Integer> features) {
        this.protocolVersion = protocolVersion;
        this.features = features;
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_TWO_ITEMS);
        packer.addPayload(IProtoConstant.RAW_IPROTO_VERSION);
        packer.packInt(this.protocolVersion);
        packer.addPayload(IProtoConstant.RAW_IPROTO_FEATURES);
        packer.packValue((Value)ValueFactory.newArray(this.features.stream().map(ValueFactory::newInteger).collect(Collectors.toList())));
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() {
        HashMap<Value, Object> map = new HashMap<Value, Object>();
        map.put(IProtoConstant.MP_IPROTO_VERSION, ValueFactory.newInteger((int)this.protocolVersion));
        map.put(IProtoConstant.MP_IPROTO_FEATURES, ValueFactory.newArray(this.features.stream().map(ValueFactory::newInteger).collect(Collectors.toList())));
        return ValueFactory.newMap(map);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_ID;
    }

    @Override
    public int getRequestType() {
        return 73;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoId(syncId = ").append(this.getSyncId()).append(", version = ").append(this.protocolVersion).append(", features = ").append(this.features).append(")");
        }
        return this.stringBuilder.toString();
    }
}

