/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.fsm;

import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.tarantool.core.WatcherOptions;
import io.tarantool.core.connection.Connection;
import io.tarantool.core.exceptions.ClientException;
import io.tarantool.core.protocol.IProtoRequest;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.core.protocol.fsm.IProtoStateMachine;
import io.tarantool.core.protocol.requests.IProtoWatch;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherStateMachine
implements IProtoStateMachine {
    private final Connection connection;
    private static final Logger log = LoggerFactory.getLogger(WatcherStateMachine.class);
    private final IProtoRequest request;
    private final String key;
    private final Consumer<IProtoResponse> callback;
    private final Timer timerService;
    private final WatcherOptions opts;
    private boolean calledOnce;

    public WatcherStateMachine(String key, long syncId, Consumer<IProtoResponse> callback, Connection connection, WatcherOptions opts, Timer timerService) {
        this.key = key;
        this.connection = connection;
        this.callback = callback;
        this.request = new IProtoWatch(key);
        this.request.setSyncId(syncId);
        this.opts = opts;
        this.timerService = timerService;
    }

    @Override
    public void runOnce() {
        if (this.calledOnce) {
            throw new IllegalStateException("runOnce() is called before, cannot be called again.");
        }
        this.calledOnce = true;
        this.send();
    }

    @Override
    public boolean process(IProtoResponse message) {
        log.debug("WatcherStateMachine:process() - \"{}\"", (Object)message);
        if (!message.isError()) {
            this.callback.accept(message);
            if (this.connection.isConnected()) {
                this.send();
            }
        } else {
            log.warn("got error for watcher: {}", (Object)message);
            this.opts.getErrorHandler().accept(this.key, new ClientException("watcher error: %s", message));
        }
        return false;
    }

    @Override
    public void kill(Throwable exc) {
    }

    private void onSendComplete(Void r, Throwable exc) {
        if (exc != null) {
            log.warn("could not send IPROTO_WATCH packet: %s", exc);
        } else {
            log.debug("IPROTO_WATCH sent");
        }
    }

    private void send() {
        CompletionStage future = this.connection.send(this.request).whenComplete(this::onSendComplete);
        Timeout timer = this.timerService.newTimeout(arg_0 -> WatcherStateMachine.lambda$send$0((CompletableFuture)future, arg_0), this.opts.getSendTimeout(), TimeUnit.MILLISECONDS);
        ((CompletableFuture)future).whenComplete((r, exc) -> timer.cancel());
    }

    private static /* synthetic */ void lambda$send$0(CompletableFuture future, Timeout timeoutHandler) throws Exception {
        if (!future.isDone()) {
            future.completeExceptionally(new ClientException("watcher timeout"));
        }
    }
}

