/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.concurrent.GenericFutureListener;
import io.tarantool.core.connection.Connection;
import io.tarantool.core.connection.ConnectionChannelInitializer;
import io.tarantool.core.connection.ConnectionCloseEvent;
import io.tarantool.core.connection.Greeting;
import io.tarantool.core.connection.exceptions.ConnectionClosedException;
import io.tarantool.core.connection.exceptions.ConnectionException;
import io.tarantool.core.protocol.IProtoMessage;
import io.tarantool.core.protocol.IProtoResponse;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
implements Connection {
    private static final String ERR_CONNECT_FAILED = "Failed to connect to the Tarantool server at %s";
    private static final String ERR_CONNECTED = "Connection is established";
    private static final String ERR_CONNECTING = "Connection is establishing";
    private static final String ERR_CLOSING = "Connection is closing";
    private static final String ERR_WAITING = "Connection is waiting for greeting";
    private static final String ERR_CLOSED_BY_CLIENT = "Connection closed by client";
    private static final String ERR_CLOSED_BY_SERVER = "Connection closed by server";
    private static final String ERR_CLOSED_BY_SHUTDOWN = "Connection closed by shutdown";
    private static final String ERR_NOT_CONNECTED = "Connection is not established";
    private static final String ERR_SEND_FAILURE = "Failed to send IProto message: %s";
    static final Logger log = LoggerFactory.getLogger(ConnectionImpl.class);
    private final Bootstrap bootstrap;
    private final Timer timerService;
    private final AtomicReference<State> state;
    private final AtomicReference<CloseReason> closedBy;
    private final Map<ConnectionCloseEvent, List<BiConsumer<Connection, Throwable>>> closeListeners;
    private final FlushConsolidationHandler flushConsolidationHandler;
    private Channel channel;
    private Greeting greeting;
    private final SslContext sslContext;
    private Consumer<IProtoResponse> consumer;
    private CompletableFuture<Greeting> connectPromise;
    private Timeout timeoutHandler;

    protected ConnectionImpl(Bootstrap bootstrap, Timer timerService) {
        this(bootstrap, null, timerService, null);
    }

    protected ConnectionImpl(Bootstrap bootstrap, SslContext sslContext, Timer timerService, FlushConsolidationHandler flushConsolidationHandler) {
        this.bootstrap = bootstrap;
        this.state = new AtomicReference<State>(State.CLOSED);
        this.closedBy = new AtomicReference<CloseReason>(CloseReason.NO_REASON);
        this.closeListeners = new ConcurrentHashMap<ConnectionCloseEvent, List<BiConsumer<Connection, Throwable>>>();
        this.sslContext = sslContext;
        this.timerService = timerService;
        this.flushConsolidationHandler = flushConsolidationHandler;
    }

    @Override
    public Connection listen(Consumer<IProtoResponse> listener) {
        log.debug("Added consumer");
        this.consumer = listener;
        return this;
    }

    @Override
    public synchronized CompletableFuture<Greeting> connect(InetSocketAddress address, long timeoutMs) throws IllegalStateException {
        if (this.state.compareAndSet(State.CLOSED, State.CONNECTING)) {
            this.closedBy.set(CloseReason.NO_REASON);
            log.debug("{} is connecting to {}", (Object)this, (Object)address);
            CompletableFuture<Greeting> promise = new CompletableFuture<Greeting>();
            this.scheduleGreetingTimeout(promise, timeoutMs);
            this.connectPromise = promise.thenApply(greeting -> {
                this.cancelGreetingTimeout();
                log.info("{} connected to {}", (Object)this, (Object)address);
                this.greeting = greeting;
                this.state.set(State.READY);
                return greeting;
            });
            this.channel = ((Bootstrap)this.bootstrap.handler((ChannelHandler)this.getInitializer(promise, this.sslContext))).remoteAddress((SocketAddress)address).connect().addListener((GenericFutureListener)this.onChannelConnect(promise, address)).channel();
        } else if (this.state.get() == State.CLOSING) {
            throw new IllegalStateException(this.state.get().getMessage());
        }
        return this.connectPromise;
    }

    @Override
    public CompletableFuture<Void> send(IProtoMessage msg) throws IllegalStateException {
        if (this.state.get() != State.READY) {
            String errorMessage = this.closedBy.get() != CloseReason.NO_REASON ? this.closedBy.get().getMessage() : this.state.get().getMessage();
            throw new IllegalStateException(errorMessage);
        }
        CompletableFuture<Void> promise = this.newPromise();
        this.channel.writeAndFlush((Object)msg).addListener(f -> {
            if (f.isSuccess()) {
                log.debug("Message \"{}\" has been sent", (Object)msg);
                this.completePromise(promise, null);
                return;
            }
            this.failPromise(promise, new ConnectionException(String.format(ERR_SEND_FAILURE, msg), f.cause()));
        });
        return promise;
    }

    @Override
    public void close() {
        log.info(ERR_CLOSED_BY_CLIENT);
        this.closeChannel(CloseReason.CLOSED_BY_CLIENT);
    }

    @Override
    public void shutdownClose() {
        log.info("Connection closed during shutdown");
        this.closeChannel(CloseReason.CLOSED_BY_SHUTDOWN);
    }

    private synchronized void closeChannel(CloseReason reason) {
        if (this.state.get() == State.CLOSED || this.state.get() == State.CLOSING) {
            return;
        }
        if (this.channel == null) {
            return;
        }
        this.closedBy.set(reason);
        this.state.set(State.CLOSING);
        this.channel.pipeline().close();
    }

    @Override
    public Optional<Greeting> getGreeting() {
        return Optional.ofNullable(this.greeting);
    }

    @Override
    public boolean isConnected() {
        return this.state.get() == State.READY;
    }

    @Override
    public Connection onClose(ConnectionCloseEvent event, BiConsumer<Connection, Throwable> callback) {
        if (!this.closeListeners.containsKey((Object)event)) {
            this.closeListeners.put(event, new ArrayList());
        }
        this.closeListeners.get((Object)event).add(callback);
        return this;
    }

    private ConnectionChannelInitializer getInitializer(CompletableFuture<Greeting> promise, SslContext sslContext) {
        ConnectionChannelInitializer.Builder initializerBuilder = new ConnectionChannelInitializer.Builder().withConnectPromise(promise).withMessageHandler(this::handleMessage).withFlushConsolidationHandler(this.flushConsolidationHandler).withCloseHandler(this::onChannelClose);
        if (sslContext == null) {
            return initializerBuilder.build();
        }
        return initializerBuilder.withSSLContext(sslContext).build();
    }

    private ChannelFutureListener onChannelConnect(CompletableFuture<Greeting> promise, InetSocketAddress address) {
        return f -> {
            if (!f.isSuccess()) {
                this.failPromise(promise, new ConnectionException(String.format(this.closedBy.get().getMessage(), address), f.cause()));
                return;
            }
            this.state.compareAndSet(State.CONNECTING, State.WAITING);
        };
    }

    private synchronized void onChannelClose(ChannelFuture f) {
        ConnectionCloseEvent event;
        String message;
        CloseReason lastCloseReason = this.closedBy.get();
        switch (lastCloseReason.ordinal()) {
            case 2: {
                message = lastCloseReason.getMessage();
                event = ConnectionCloseEvent.CLOSE_BY_SHUTDOWN;
                break;
            }
            case 1: {
                message = lastCloseReason.getMessage();
                event = ConnectionCloseEvent.CLOSE_BY_CLIENT;
                break;
            }
            default: {
                message = ERR_CLOSED_BY_SERVER;
                event = ConnectionCloseEvent.CLOSE_BY_REMOTE;
            }
        }
        if (this.state.get() != State.CONNECTING) {
            ConnectionClosedException ex = new ConnectionClosedException(message, f.cause());
            this.failConnectPromise(ex);
            this.fire(event, ex);
        }
        this.state.set(State.CLOSED);
        this.channel = null;
        this.connectPromise = null;
    }

    private <T> CompletableFuture<T> newPromise() {
        CompletableFuture promise = new CompletableFuture();
        return promise;
    }

    private <T> void completePromise(CompletableFuture<T> promise, T result) {
        if (!promise.isDone()) {
            promise.complete(result);
        }
    }

    private <T> void failPromise(CompletableFuture<T> promise, Exception ex) {
        if (!promise.isDone()) {
            promise.completeExceptionally(ex);
        }
    }

    private void failConnectPromise(Exception ex) {
        if (this.connectPromise != null && !this.connectPromise.isDone()) {
            this.connectPromise.completeExceptionally(ex);
        }
    }

    private void fire(ConnectionCloseEvent event, Throwable ex) {
        if (!this.closeListeners.containsKey((Object)event)) {
            return;
        }
        List<BiConsumer<Connection, Throwable>> handlers = this.closeListeners.get((Object)event);
        for (BiConsumer<Connection, Throwable> handler : handlers) {
            handler.accept(this, ex);
        }
    }

    private void scheduleGreetingTimeout(CompletableFuture<Greeting> promise, long timeoutMs) {
        log.info("Schedule timeout for connect: {}", (Object)timeoutMs);
        if (timeoutMs <= 0L) {
            throw new IllegalStateException("Timeout must be greater than zero!");
        }
        this.timeoutHandler = this.timerService.newTimeout(timeoutHandler -> {
            if (promise.isDone()) {
                return;
            }
            if (this.state.get() == State.CONNECTING || this.state.get() == State.WAITING) {
                this.channel.pipeline().close();
                promise.completeExceptionally(new TimeoutException("Connection timeout"));
            }
        }, timeoutMs, TimeUnit.MILLISECONDS);
    }

    private void cancelGreetingTimeout() {
        if (this.timeoutHandler == null) {
            return;
        }
        log.debug("Cancel timeout");
        this.timeoutHandler.cancel();
        this.timeoutHandler = null;
    }

    private void handleMessage(IProtoResponse message) {
        if (this.consumer != null) {
            this.consumer.accept(message);
        }
    }

    private static enum State {
        CLOSED("Connection is not established"),
        CONNECTING("Connection is establishing"),
        WAITING("Connection is waiting for greeting"),
        READY("Connection is established"),
        CLOSING("Connection is closing");

        private final String message;

        private State(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private static enum CloseReason {
        NO_REASON("Failed to connect to the Tarantool server at %s"),
        CLOSED_BY_CLIENT("Connection closed by client"),
        CLOSED_BY_SHUTDOWN("Connection closed by shutdown");

        private final String message;

        private CloseReason(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

