/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.mapping;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.tarantool.core.protocol.ByteBodyValueWrapper;
import io.tarantool.mapping.JacksonMappingException;
import io.tarantool.mapping.TarantoolDeserializer;
import io.tarantool.mapping.TarantoolJacksonMapping;
import io.tarantool.mapping.Tuple;
import io.tarantool.mapping.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;

public class TupleExtensionModule {
    private static final ThreadLocal<StringBuilder> threadLocalStringBuilder;
    public static final SimpleModule INSTANCE;
    public static final JavaType JAVA_TYPE_OBJECT;

    static {
        INSTANCE = new SimpleModule("msgpack-ext-tuple");
        JAVA_TYPE_OBJECT = new ObjectMapper().getTypeFactory().constructFromCanonical(Object.class.getName());
        threadLocalStringBuilder = ThreadLocal.withInitial(StringBuilder::new);
        INSTANCE.addSerializer(Tuple.class, (JsonSerializer)new TupleSerializer(Tuple.class));
        INSTANCE.addDeserializer(Tuple.class, (JsonDeserializer)new TupleDeserializer());
    }

    public static class TupleSerializer
    extends StdSerializer<Tuple> {
        public TupleSerializer(Class<Tuple> t) {
            super(t);
        }

        public void serialize(Tuple tuple, JsonGenerator gen, SerializerProvider provider) throws IOException {
            try (MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();){
                packer.packLong((long)tuple.getFormatId().intValue());
                packer.addPayload(TarantoolJacksonMapping.toValueAux(tuple.get()));
                gen.writeObject((Object)new MessagePackExtensionType(7, packer.toByteArray()));
            }
        }
    }

    public static class TupleDeserializer
    extends JsonDeserializer<Tuple<?>>
    implements TarantoolDeserializer<Tuple<?>>,
    ContextualDeserializer {
        private JavaType valueType;

        public TupleDeserializer(JavaType valueType) {
            this.valueType = valueType;
        }

        public TupleDeserializer() {
            this.valueType = JAVA_TYPE_OBJECT;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            List parameters = ctxt.getContextualType().getBindings().getTypeParameters();
            JavaType type = JAVA_TYPE_OBJECT;
            if (!parameters.isEmpty()) {
                type = (JavaType)parameters.get(0);
            }
            return new TupleDeserializer(type);
        }

        public Tuple<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.currentTokenId() != 12) {
                return new Tuple<Object>(ctxt.readValue(p, this.valueType), null, Collections.emptyList());
            }
            MessagePackExtensionType ext = (MessagePackExtensionType)p.readValueAs(MessagePackExtensionType.class);
            if (ext.getType() != 7) {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new JacksonMappingException(sb.delete(0, sb.length()).append("Unexpected extension type (0x").append(Utils.byteToHex(ext.getType())).append(") for TUPLE object").toString());
            }
            return this.deserialize(ext);
        }

        @Override
        public Tuple<?> deserialize(MessagePackExtensionType ext) throws IOException {
            byte[] data = ext.getData();
            try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])data);){
                int formatId = unpacker.unpackInt();
                int read = (int)unpacker.getTotalReadBytes();
                Tuple tuple = new Tuple(TarantoolJacksonMapping.readValueAux(new ByteBodyValueWrapper(data, read, data.length - read), this.valueType), formatId, Collections.emptyList());
                return tuple;
            }
        }
    }
}

